import java.util.*;

public class Bombons {
    static class Node implements Comparable<Node> {
        int cost, x, y;

        public Node(int cost, int x, int y) {
            this.cost = cost;
            this.x = x;
            this.y = y;
        }

        @Override
        public int compareTo(Node other) {
            return Integer.compare(this.cost, other.cost);
        }
    }

    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        while (true) {
            // Entrada de L, C e T
            int L = scanner.nextInt();
            int C = scanner.nextInt();
            int T = scanner.nextInt();

            if (L == 0 && C == 0 && T == 0) {
                break;
            }

            // Inicializa a matriz
            int[][] grid = new int[L][C];
            for (int i = 0; i < L; i++) {
                for (int j = 0; j < C; j++) {
                    grid[i][j] = scanner.nextInt();
                }
            }

            // Posição inicial e final
            int L1 = scanner.nextInt() - 1;
            int C1 = scanner.nextInt() - 1;
            int L2 = scanner.nextInt() - 1;
            int C2 = scanner.nextInt() - 1;

            // Dijkstra
            PriorityQueue<Node> pq = new PriorityQueue<>();
            pq.add(new Node(grid[L1][C1], L1, C1));
            boolean[][] vis = new boolean[L][C];
            int[][] dist = new int[L][C];
            for (int[] row : dist) {
                Arrays.fill(row, Integer.MAX_VALUE);
            }
            dist[L1][C1] = grid[L1][C1];

            int[][] dir = {{0, 1}, {1, 0}, {0, -1}, {-1, 0}};

            while (!pq.isEmpty()) {
                Node node = pq.poll();
                int val = node.cost, x = node.x, y = node.y;

                if (vis[x][y]) continue;
                vis[x][y] = true;

                for (int[] d : dir) {
                    int a = x + d[0], b = y + d[1];
                    if (a < 0 || a >= L || b < 0 || b >= C || grid[a][b] == -1 || vis[a][b]) {
                        continue;
                    }
                    if (dist[a][b] > dist[x][y] + grid[a][b]) {
                        dist[a][b] = dist[x][y] + grid[a][b];
                        pq.add(new Node(dist[a][b], a, b));
                    }
                }
            }

            int caminhoMinimo = dist[L2][C2] - grid[L2][C2];
            int bombons = T / caminhoMinimo;

            System.out.println(bombons);
        }

        scanner.close();
    }
}
